/*
 * Full screen slide show starter
 *
 * This script opens the selected slide show in full screen mode, then reverts to normal screen mode when the show finishes.
 * When this page is first called by some indeterminate page, its window name is unknown, but should not be 'diapo'.
 * When it starts a slide show, it opens a new window with the name 'diapo', but remains present, hidden behind the new window.
 * The slide show returns by recalling this page into the still active 'diapo' window, which is then deleted by this script,
 * making the original page visible again.
 *
 * Note : Crtl/W or Alt/F4 may be used to close the current window. This exits the browser if the current window is the only one.
 */
  diapo = 'diapo';			// give a name to the window to be opened by show()
  moi = window.name;			// window name of the calling page
  if (moi == diapo) window.close(diapo); // if same, it's a return from the slide show
  top.moveTo(0,0);			// maximize this window
  top.resizeTo(window.screen.availWidth, window.screen.availHeight);

  function show(slide){ window.open(slide, diapo, "fullscreen=yes "); }	// start a slide show in new window
