/*
 * ====== Slide Show v3.4 == (c) H. Mueller 2009 ======
 *	Last revision : 12-mar-2011
 *
 * Common JavaScript code loaded by all slideX.htm pages
 *
 * The picture files must be numbered from nmin to nmax, the number
 *  being the last 3 digits of the picture file name (ex: pic027.jpg).
 *  Leading zeros are mandatory.
 * This procedure uses variables and params defined in file "slideParam.js".
 *
 * Modifications
 *	101016	dynamic slide show operation (default timing = 8000 ms)
 *	101027	added variable 'timing' to specify delay in ms
 */

document.write('<title>'+picsetname+'</title>');
docurl = document.URL				// URL of current document
separ = "#"					// assume old URL syntax : filespec#picnumber
//var picTimeout;					// timer handle as global variable
if (docurl.lastIndexOf("?") > 0) separ = "="	// new URL syntax : filespec?n=picnumber (form action) 
idxA = docurl.lastIndexOf(".")		// locate end of file name
sfx = docurl.substring(idxA-1, idxA)	// last char of file name. Must be A or B (upper case)
if(sfx == "A") sfx = "B"; else sfx="A"	// toggle for next picture
nextURL = docurl.substring(0, idxA-1)+sfx	// alternate document name

idxB = docurl.lastIndexOf(separ)		// locate pic number string (if none start with ncur)
if (idxB > 0) { ncur = docurl.substring(idxB+1); docurl = docurl.substring(0, idxB); }

if (separ != "#") separ = "?"			// skip syntax element "?n=" 
idxB = docurl.lastIndexOf(separ)		// locate end of document name
if (idxB > 0) { docurl = docurl.substring(0, idxB); } // doc name without trailing params
  else idxB = docurl.length;			// no separ in string
htmltype = docurl.substring(idxA, idxB); 	// html file type

separ = "#"						// prepare for name of next document

//alert('0 ncur='+ncur+' nmin='+nmin+' nmax='+nmax);

if (ncur < nmin-0) ncur = nmin;		// check limits
if (ncur > nmax-0) ncur = nmax;		// ("-0" converts string to numeric)

//alert(nextURL+' \n '+idxA+' '+idxB+' type='+htmltype)

/* ********************************************* *
 * Array 'redir' allows to specify for any picture number one of the following :
 * - if redir[ncur] is undefined : fall thru, doing nothing
 * - if redir[ncur] contains a null string : skip a non-existing picture
 * - if redir[ncur] is numeric : use as alternate picture number
 * - if the first char of redir[ncur] is dot : use this as alternate pictype (possible: .gif, .jpg, .png)
 * - if redir[ncur] is non numeric (page name): load this page, effectively terminating the current show
 */
while ((redir[ncur] != undefined) && (redir[ncur] == '')) ncur++;	// skip any explicitly empty entry 
nsubst = ''+ncur;				// assume picture substitution (note: ''+ is cast to string variable)

if (redir[nsubst] != undefined) {	// possible substitution
  nsubst = redir[nsubst];
  if ((nsubst.charAt(0) == '.') && (nsubst.charAt(1) != '/') && (nsubst.charAt(2) != '/'))
    { pictype = nsubst; nsubst = ncur; } //  change pictype to .gif or .jpg or .png ...
  else for (i = 0; i < nsubst.length; i++) if ((nsubst.charAt(i) < '0') || (nsubst.charAt(i) > '9'))
    window.location = nsubst;		// escape show and load new page
//  nsubst = nsubst-0;			// note: -0 is cast to binary variable
} // if (redir[nsubst] != undefined)

if (nsubst.length < 3) root += '0'	// append leading zeros
if (nsubst.length < 2) root += '0'	// ...
if (nsubst.length < 1) root += '1';	// default empty string to 1
if (nametab[nsubst] !== undefined) { root = ''; nsubst = nametab[nsubst]; }	// name translation present
//alert('nsubst='+nsubst+' root='+root+' pictype='+pictype);

/* ********************************************* */

function winWidth()		// actual width of window
{
 if (window.innerWidth) return window.innerWidth;
 else if (document.body && document.body.offsetWidth) return document.body.offsetWidth;
 else return 0;
}

/* ********************************************* */

function winHeight()		// actual height of window
{
 if (window.innerHeight) return window.innerHeight  ;
 else if (document.body && document.body.offsetHeight) return document.body.offsetHeight;
 else return 0;
}

/* ********************************************* */

function refresh()		// on window resizing
{
 if (winW != winWidth() || winH != winHeight()) window.history.go(0);
}

/* ********************************************* */

function showerr() { alert(errmsg01+ncur); }

/* ********************************************* */

exitRequest = 0;
function sortie() {
//  top.location.replace("index.htm");
exitRequest = 1;
  alert("Sortie");
}

/* ********************************************* */

loaded = 0;				// execute once flag
function showpic()		// resize picture to window size
{
  if (loaded == 0)
  {
    loaded = 1;
    picW = document.diapo.width;
    picH = document.diapo.height;
    if (!(optmask & 1) && (picH > winH)) return; // no size decrease
    if (!(optmask & 2) && (picH < winH)) return; // no size increase
    if (picH > 0) z = picW / picH;
    if (z == 0) z = 1;
    if (winW/winH < z) winH = Math.floor(winW/z);	// resize picture to fit available...
    if (winW/winH > z ) winW = Math.floor(winH*z);	//   ... window space
    document.diapo.width = winW;
    document.diapo.height = winH;
  }
} 

/* ********************************************* */
function cancelTimedShow()
{
  clearTimeout(picTimeout);		// must click to load next pic
//  alert('Timer cancelled');
}
function timedShow()
{
//  alert('Next slide');
  window.location = nextURL+htmltype+separ+xcur; // timed load of next picture
}
/* ********************************************* */

function fetchNextPic()
{

if(!window.winW && window.innerWidth)	// Init resize watch for Mozilla
  {
   window.onresize = refresh;
   winW = winWidth()-16;	// 16 = estimated width of scroll bar for Mozilla
   winH = winHeight()-16;
  }

// Fetch next picture to an IMG with unspecified size for getting the actual picture size.
// It will be resized to the actual window size by the onLoad handler.

  xcur = ncur;				// number of next picture
  do { xcur++; } while ((redir[xcur] != undefined) && (redir[xcur] == ''))	// forward skip null string substitutions
  if (xcur > nmax) xcur = nmin;	// wrap if required
  xprec = ncur;				// number of previous picture
  do { xprec--; } while ((redir[xprec] != undefined) && (redir[xprec] == ''))	// reverse skip null string substitutions
  if (xprec < nmin) { xprec = nmax; while (redir[xprec] != undefined) xprec--; } // wrap if required
 
// An exit from the slide show is provided by laying out the picture as a map:
//	- a click on the center of the picture loads the next picture
//	- a click on the left upper corner exits to the home page
  picdoc = "";
  if (zkx0) picdoc = zkx0;
  if (zkx[ncur]) picdoc = zkx[ncur];
  if (parseInt(picdoc)) picdoc = zkx[picdoc];
  if (''+picoffs != '') { npic = ncur-picoffs; picdoc = npic+'  '+picdoc; }	// relative picture number
//alert('fetchNextPic name='+root+nsubst+pictype);
  document.write('<img src="'+root+nsubst+pictype+'" border="0" title="'+picdoc+'"');
  if (typeof(hauteur) != 'undefined')  document.write(' style="height: '+hauteur+'" ');	// image height, if explicit
  document.write('name="diapo" onError="showerr()" onLoad="showpic()" usemap="#photo">');
  document.write('<map name="photo"><area SHAPE="rect" COORDS="0,0,33,33" href="'+homepage+'" title="exit">');
  document.write('<area SHAPE="rect" COORDS="33,0,66,33" href="'+nextURL+htmltype+separ+xprec+'" title="&nbsp;&lt;&lt;&nbsp;">');
  document.write('<area SHAPE="rect" COORDS="200,0,1000,33" href="javascript: cancelTimedShow()" title="&nbsp;zzz&nbsp;">');
  document.write('<area SHAPE="rect" COORDS="66,33,1000,800" href="'+nextURL+htmltype+separ+xcur+'"></map>');
  if (typeof(pictimer) == 'undefined') pictimer = 8000; // set default delay if required (in milliseconds)
  if (pictimer != 0) picTimeout = setTimeout("timedShow()", pictimer);	// zero means manual show
}

/* ********************************************************************
 * Navigation bar generation
 *	previous      caption               next exit
 *	+----+-----------------------------+----+---+
 *	| <- |  Slide caption              | -> | X |
 *	+----+-----------------------------+----+---+
 *
 *	npic	number of previous or next picture ('' for exit)
 *	iname	name of navigation symbol picture (arrow or X)
 *	style	name of box style class (defined in file "slideStyle.css")
 *
 *	optmask&4	navigation bar present flag
 *	picpath 	path of folder containing the symbol pictures (ex: ../pics/)
 *	picoffs 	offset of picture numbering in caption. If null string : no numbering
 *	(These and other variables and params are defined in file "slideParam.js")
 */
function navig(npic, iname, style)	// clickable : previous - next - exit
{
  document.write('<td class="'+style+'"><a href="');
  if (npic == '') document.write(homepage);
    else document.write(nextURL+htmltype+separ+npic);
  document.write('"><img src="'+picpath+iname+'" alt="" border="0"></a></td>');
}

function caption(npic, style)		// slide caption
{
  if (zkx0) picdoc = zkx0;
  if (zkx[ncur]) picdoc = zkx[ncur];
  if (parseInt(picdoc)) picdoc = zkx[picdoc];
  if (''+picoffs != '') { npic = npic-picoffs; picdoc = npic+' - '+picdoc; }
  document.write('<td class="'+style+'">'+picdoc+'</td>');
}

function navbar()		// display the navigation bar (implementation dependent)
				// style classes t0, t1, t2 defined in "slideStyle.css"
{
  if (optmask & 4) {	// optional display (if flag set)
    navig(xprec,'ArrowLeft.gif','t1');	// previous
    caption(ncur,'t0');				// caption
    navig(xcur,'ArrowRight.gif','t2');	// next
    navig('','exit.gif','t1');		// exit
  } // if (optmask & 4)
}

