/* slideParams.js - Must be edited according to the actual parameters of the slide show
 * 		v2.2	H. Mueller	25-aug-2011
 */
picsetname = "Digibutler";	// <title> of the slide show </title>
nmin = '3';				// first slide (must be defined as string). Value 0 is usually reserved.
nmax = '13';			// last slide (includes the exit target)
ncur = nmin;			// current slide (initial value -> start slide)
base = '../';			// path of the root directory (must have trailing slash)
picpath = base+'pics/';		// path to common pictures (must have trailing slash)
root = 'digib';			// picture file name root (format 'root'nnn.jpg)
pictype = '.jpg';			// picture type (must be the same for all pictures)
picoffs = nmin-1;			// caption numbering offset = ncur-picoffs (suppressed if null string)
homepage = 'index.html';		// slide show home page
slide0 = root+'000'+pictype;	// name of the picture used by the home page
optmask = 0;			// options mask. Bit if set :
					// 0 downsize large image to window size
					// 1 magnify small image to window size
					// 2 navigation bar present

errmsg01 = "No picture n "	// picture not available alert (translate to local language)
zkx0 = "Digibutler"; // default for missing slide caption (translate to local language)

/* -----------------------------------------------------------------------
 * Array zkx[] contains one caption entry per slide used for the TITLE attribute
 * of the <IMG> tag.
 * It must be maintained manually to stay in correspondence with the numbering of 
 * the slides (usually from fist to last)
 *
 * Text redundancy compression. It is expected that a significant number of slides use
 * the same caption. For storing this caption only once, by convention, if a caption is
 * an integer, its value is used as redirection index for the actual caption.
 * Example:
 *	zkx[12] = "7";	// slide 12 uses the same caption as slide 7
 * This operation is NOT recursive.
 */
zk = 0;			// init array index
var zkx = new Array;	// create slide caption array

zkx[zk] = "Digibutler";
zks = zk;

/* -----------------------------------------------------------------------
 * Array redir[]  redirection array. Each entry :
 * - if undefined : its index is used as 3 digit suffix of the name of the slide to load
 * - if it contains a null string : this entry is ignored and skipped (no associated slide)
 * - if it contains a 3 digit numeric value : this value replaces the index as the index
 *   of the slide to load (warning : recursive ! Beware of redirection loops !)
 * - if it exists and contains a non numeric string : this is the link of the next page to load.
 */
var redir = new Array;	// redirection array
redir[7] = "";
redir[nmax] = homepage;	// exit to this page at end (possibly homepage)
